#include <bits/stdc++.h>
#define endl '\n'

int m, n, k = 0;
int result = 0;

using namespace std;

bool possible(int busFuel, int pump[], int requiredFuel[]){
    for(int i = 0; i < n - 1; i++){
        busFuel += pump[i];
        if(busFuel < requiredFuel[i + 1]) return false;
        busFuel -= requiredFuel[i + 1];
    }

    return true;
}

bool calculate(int busFuel, int pump[], int requiredFuel[]){
    int reqBusFuel[n];
    reqBusFuel[n - 1] = requiredFuel[n - 1] - pump[n - 2];

    for(int i = n - 2; i > 0; i--){
        reqBusFuel[i] = reqBusFuel[i + 1] + requiredFuel[i] - pump[i - 1];
    }

    if(reqBusFuel[1] > busFuel){
        return false;
    }

    for(int i = 1; i < n; i++){
        int fuelGrabbed = max(0, requiredFuel[i] - busFuel);
        pump[i - 1] -= fuelGrabbed;
        busFuel += fuelGrabbed - requiredFuel[i];
    }

    result++;
    return true;
}

int calculateLeastFuelNeeded(int busFuel, int pump[], int requiredFuel[], int pumpIndex){
    int fuelNeeded = 0;
    for(int i = n - 1; i >= pumpIndex; i--){
        fuelNeeded += requiredFuel[i];
        fuelNeeded -= pump[i - 1];
    }

    return fuelNeeded;
}

bool takeFuel(int busNew[], int pump[], int fuelReq, int busIndex, int pumpIndex){
    for(int i = pumpIndex - 1; i >= 0; i--){
        int busFuel = busNew[busIndex];
        int fuelNeeded = fuelReq - busFuel;

        int fuel = pump[i];
        if(fuel > fuelNeeded){
            fuel = fuelNeeded;
            pump[i] -= fuel;
            busNew[busIndex] += fuel;
            return true;
        }

        busNew[busIndex] += fuel;
        pump[i] = 0;
    }

    return busNew[busIndex] >= fuelReq;
}

int main(){
    //ios::sync_with_stdio(false); cin.tie(0);
    cin>>m>>n;

    int fuelReq = 0;
    int bus[m], stations[n], pump[n], requiredFuel[n], totalReqFuel[n];

    totalReqFuel[0] = 0;
    requiredFuel[0] = 0;

    for(int i = 0; i < m; i++) cin>>bus[i];
    for(int i = 0; i < n; i++) {
        cin>>stations[i];
        if(i > 0){
            requiredFuel[i] = abs(stations[i] - stations[i - 1]);
            fuelReq += requiredFuel[i];
            totalReqFuel[i] = totalReqFuel[i - 1] + requiredFuel[i];
        }
    }

    for(int i = 0; i < n; i++) cin>>pump[i];

    int busNew[m];
    for(int i = 0; i < m; i++){
        if(bus[i] >= fuelReq){
            result++;
        }else{
            busNew[k++] = bus[i];
        }
    }

    sort(busNew, busNew + k);

    for(int i = k - 1; i >= 0; i--){
        if(!calculate(busNew[i], pump, requiredFuel)) break;
    }

    /*bool canContinue = true;
    for(int i = k - 1; i >= 0; i--){
        for(int o = 1; o < n; o++){
            if(busNew[i] < totalReqFuel[o]){
                bool b = takeFuel(busNew, pump, totalReqFuel[o], i, o);
                if(!b){ //Nema vise goriva
                    canContinue = false;
                    break;
                }
            }else if(o == n - 1) result++;
        }

        if(!canContinue) break;
    }*/

    cout<<result;
    return 0;
}